@if(Sentinel::check())
@extends('layouts.master-staff')
@section('content')
<!-- page content -->
<div class="right_col" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h4> <a href="{{url('/staff')}}" class="fa fa-home"> Home</a> / <a href="{{url('/pengunjung')}}">Data Pengunjung </a> </h4>
            </div>
        </div>

        <div class="clearfix"></div>

        <div class="row">

            <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                    <div class="x_title">
                        <h2>Input Data Pengunjung <small>1 Tiket = Rp10000,-</small></h2>
                        <ul class="nav navbar-right panel_toolbox">
                            <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                            </li>
                        </ul>
                        <div class="clearfix"></div>
                    </div>


                    <div class="x_content">
                        @if(Session::has('alert-success'))
                            <div class="alert alert-success">
                                {{ Session::get('alert-success') }}
                            </div>
                        @endif
                        @if(!empty($errors->first()))
                            <div class='alert alert-warning'>{!! $errors->first() !!}</div>
                        @endif
                        <form action="{{url('/pengunjung/store')}}" method="post" data-parsley-validate class="form-horizontal form-label-left">
                            {{csrf_field()}}

                            <div class="form-group{{ $errors->has('nama_pengunjung') ? ' has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="first-name">Nama Pengunjung
                                    <span class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    <input type="text" name="nama_pengunjung" required="required" class="form-control col-md-7 col-xs-12">
                                    {!! $errors->first('nama_pengunjung', '<p class="help-block">:message</p>') !!}
                                </div>
                            </div>

                            <div class="form-group{{ $errors->has('jumlah') ? ' has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="first-name">Jumlah Tiket<span class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    <input type="number" onkeyup="Harga(this.value)" min="1" name="jumlah" required="required" class="form-control col-md-7 col-xs-12">
                                    {!! $errors->first('jumlah', '<p class="help-block">:message</p>') !!}
                                </div>
                            </div>

                            <div class="form-group{{ $errors->has('total_harga') ? ' has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="first-name">Total Harga (Rp)<span class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    <span class="form-control col-md-7 col-xs-12" id="total_harga" name="total_harga"></span>
                                    {!! $errors->first('total_harga', '<p class="help-block">:message</p>') !!}
                                </div>
                            </div>
                            <script>function Harga(str)
                                {
                                    document.getElementById("total_harga").innerHTML = str*10000;
                                    return;
                                }
                            </script>

                            <div class="ln_solid"></div>
                            <div class="form-group">
                                <div class="col-md-6 col-sm-6 col-xs-12 col-md-offset-3">
                                    <button class="btn btn-primary" type="reset">Reset</button>
                                    <button type="submit" class="btn btn-success">Simpan</button>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>


            <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                    <div class="x_title">
                        <h2><b>Data Pengunjung dan Pembelian Tiket Manual</b></h2>
                        <ul class="nav navbar-right panel_toolbox">
                            <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                            </li>
                        </ul>
                        <div class="clearfix"></div>
                    </div>

                    <div class="x_content">
                        <table class="table table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Nama</th>
                                <th>Jumlah Tiket</th>
                                <th>Total Harga</th>
                                <th>Tanggal Berkunjung</th>
                                <th>Status</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $no=1; ?>
                            @foreach($pengunjungs as $peng)
                                <tr>
                                    <td>{{$no++}}</td>
                                    <td>{{$peng->nama_pengunjung}}</td>
                                    <td>{{$peng->jumlah}}</td>
                                    <td>{{$peng->total_harga}}</td>
                                    <td>{{$peng->created_at}}</td>
                                    <td>Lunas</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- /page content -->
@endsection
@endif
