package com.app.ecoforta.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.app.ecoforta.dao.ProdukDao;
import com.app.ecoforta.model.Produk;

@Service("produkService")
@Transactional
public class ProdukServiceImpl implements ProdukService
{
	@Autowired
    private ProdukDao dao;
	
	@Override
	public Produk findById(int id) {
		return dao.findById(id);
	}

	@Override
	public void saveProduk(Produk produk) {
		dao.saveProduk(produk);
	}

	@Override
	public void updateProduk(Produk produk) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void deleteProdukById(int id) {
		dao.deleteProdukById(id);
	}

	@Override
	public List<Produk> findAllProduks() {
		return dao.findAllProduks();
	}

	@Override
	public Produk findProdukById(int id) {
		return dao.findProdukById(id);
	}
}
