package com.app.ecoforta.dao;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import com.app.ecoforta.model.Produk;
 
@Repository("produkDao")
public class ProdukDaoImpl extends AbstractDao<Integer, Produk> implements ProdukDao
{

	@Override
	public Produk findById(int id) 
	{
		return getByKey(id);
	}

	@Override
	public void saveProduk(Produk produk) 
	{
		persist(produk);
	}

	@Override
	public void deleteProdukById(int id) 
	{
		 Query query = getSession().createSQLQuery("delete from Produk where id = :id");
	        query.setInteger("id", id);
	        query.executeUpdate();
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Produk> findAllProduks() 
	{
		Criteria criteria = createEntityCriteria();
        return (List<Produk>) criteria.list();
	}

	@Override
	public Produk findProdukById(int id) 
	{
		Criteria criteria = createEntityCriteria();
        criteria.add(Restrictions.eq("id", id));
        return (Produk) criteria.uniqueResult();
	}

}
