<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::auth();

Route::get('/', function () {
    return redirect('/login');
});

Route::group(['middleware' => 'auth'], function () {
	Route::group(['middleware' => 'web'], function(){
		Route::group(['middleware' => 'admin'], function(){
			Route::get('/user', 'UserController@index');
			Route::get('/user/create', 'UserController@create');
			Route::post('/user/store', 'UserController@store');
			Route::get('/user/delete/{id}', 'UserController@destroy');
			Route::get('/user/edit/{id}', 'UserController@edit');
			Route::post('/user/update/{id}', 'UserController@update');

			Route::get('/class', 'ClassController@index');
			Route::get('/class/create', 'ClassController@create');
			Route::post('/class/store', 'ClassController@store');
			Route::get('/class/delete/{id}', 'ClassController@destroy');
			Route::get('/class/edit/{id}', 'ClassController@edit');
			Route::post('/class/update/{id}', 'ClassController@update');
			Route::get('/class/show/{id}', 'ClassController@show');
			Route::get('/class/add/{id}', 'ClassController@add');
			Route::post('/class/assign', 'ClassController@assign');
			Route::get('/class/resign/{class_id}/{course_id}', 'ClassController@resign');

			Route::get('/course', 'CourseController@index');
			Route::get('/course/create', 'CourseController@create');
			Route::post('/course/store', 'CourseController@store');
			Route::get('/course/delete/{id}', 'CourseController@destroy');
			Route::get('/course/edit/{id}', 'CourseController@edit');
			Route::post('/course/update/{id}', 'CourseController@update');

			Route::get('/room', 'RoomController@index');
			Route::get('/room/create', 'RoomController@create');
			Route::post('/room/store', 'RoomController@store');
			Route::get('/room/delete/{id}', 'RoomController@destroy');
			Route::get('/room/edit/{id}', 'RoomController@edit');
			Route::post('/room/update/{id}', 'RoomController@update');
		});

		Route::group(['middleware' => 'user'], function(){
			Route::get('/request', 'RequestController@index');
			Route::get('/request/canceled', 'RequestController@cancelled');
			Route::get('/request/finished', 'RequestController@finished');
			Route::get('/request/create', 'RequestController@create');
			Route::post('/request/store', 'RequestController@store');
			Route::get('/request/cancel/{id}', 'RequestController@cancel');
			Route::get('/request/edit/{id}', 'RequestController@edit');
			Route::post('/request/update/{id}', 'RequestController@update');
			Route::get('/request/done/{id}', 'RequestController@done');

			Route::get('/help', 'HelpController@index');
			Route::get('/help/accept/{id}', 'HelpController@accept');
			Route::get('/help/accepted', 'HelpController@accepted');
			Route::get('/help/finished', 'HelpController@finished');

			Route::get('/invitation', 'InvitationController@index');
			Route::get('/invitation/accepted', 'InvitationController@accepted');
			Route::get('/invitation/rejected', 'InvitationController@rejected');
			Route::get('/invitation/accept/{id}', 'InvitationController@accept');
			Route::get('/invitation/reject/{id}', 'InvitationController@reject');
		});
	});
});

Route::get('/home', 'HomeController@index');

Route::get('/403', function(){
	return view('errors.403');
});



