@extends('adminlte::layouts.app')

@section('htmlheader_title')
	Invitation
@endsection

@section('main-content')
	<div class="container-fluid spark-screen">
		<div class="row">
			<div class="col-md-12">
				<h2 class="page-header">Invitation</h2>

					<div class="panel panel-default">
					    <div class="panel-heading">
					        List of New Invitation
					    </div>

					    <div class="panel-body">
					        <div class="">
					            <table class="table table-striped" id="thegrid">
					                <thead>
					                    <tr>
					                    	<th>Requester</th>
					                        <th>Course</th>
					                        <th>Class</th>
					                        <th>Date</th>
					                        <th>Time</th>
					                        <th>Room</th>
					                        <th>Type</th>
					                        <th>Attender</th>
					                        <th>Status</th>
					                        <th style="width:155px">Action</th>
					                    </tr>
					                </thead>
					                <tbody>
					                    @foreach ($UFinvitations as $invitation)
					                        <tr>
					                        	<td>{{ $invitation->requester }}</td>
					                            <td>{{ $invitation->course_name }}</td>
					                            <td>{{ $invitation->class_name }}</td>
					                            <td>{{ $invitation->due_date }}</td>
					                            <td>{{ $invitation->due_time }}</td>
					                            <td>{{ $invitation->room_name }}</td>
					                            <td>{{ $invitation->type }}</td>
					                            <td>{{ $invitation->totalAttender }}</td>
					                            <td>{{ $invitation->status }}</td>
					                            <td> 
					                                <a href="{{ url('invitation/') }}/accept/{{$invitation->invitID}}" class="btn btn-primary"> Accept </a>
					                                <a href="{{ url('invitation/reject') }}/{{$invitation->invitID}} " class="btn btn-danger" onclick="return confirm('Are you sure to reject this invitation?')"> Reject </a>
					                            </td>
					                        <tr>
					                    @endforeach
					                </tbody>
					            </table>
					           
					        </div>
					    </div>
					</div>

					<div class="panel panel-default">
					    <div class="panel-heading">
					        List of On Progress Invitation
					    </div>

					    <div class="panel-body">
					        <div class="">
					            <table class="table table-striped" id="thegrid">
					                <thead>
					                    <tr>
					                    	<th>Requester</th>
					                        <th>Course</th>
					                        <th>Class</th>
					                        <th>Date</th>
					                        <th>Time</th>
					                        <th>Room</th>
					                        <th>Type</th>
					                        <th>Attender</th>
					                        <th>Approver</th>
					                    </tr>
					                </thead>
					                <tbody>
					                    @foreach ($Finvitations as $invitation)
					                        <tr>
					                        	<td>{{ $invitation->requester }}</td>
					                            <td>{{ $invitation->course_name }}</td>
					                            <td>{{ $invitation->class_name }}</td>
					                            <td>{{ $invitation->due_date }}</td>
					                            <td>{{ $invitation->due_time }}</td>
					                            <td>{{ $invitation->room_name }}</td>
					                            <td>{{ $invitation->type }}</td>
					                            <td>{{ $invitation->totalAttender }}</td>
					                            <td> </td>
					                        <tr>
					                    @endforeach
					                    @foreach ($FinvitationsAp as $invitation)
					                        <tr>
					                        	<td>{{ $invitation->requester }}</td>
					                            <td>{{ $invitation->course_name }}</td>
					                            <td>{{ $invitation->class_name }}</td>
					                            <td>{{ $invitation->due_date }}</td>
					                            <td>{{ $invitation->due_time }}</td>
					                            <td>{{ $invitation->room_name }}</td>
					                            <td>{{ $invitation->type }}</td>
					                            <td>{{ $invitation->totalAttender }}</td>
					                            <td>{{ $invitation->approver }}</td>
					                        <tr>
					                    @endforeach
					                </tbody>
					            </table>
					           
					        </div>
					    </div>
					</div>
			</div>
		</div>
	</div>
@endsection
