@extends('adminlte::layouts.app')

@section('htmlheader_title')
	Course
@endsection

@section('main-content')
	<div class="container-fluid spark-screen">
		<div class="row">
			<div class="col-md-12">
				<h2 class="page-header">Course</h2>

					<div class="panel panel-default">
					    <div class="panel-heading">
					        List of Course
					    </div>

					    <div class="panel-body">
					        <div class="">
					            <table class="table table-striped" id="thegrid">
					                <thead>
					                    <tr>
					                        <th>Id</th>
					                        <th>Name</th>
					                        <th style="width:150px">Action</th>
					                        <!-- <th style="width:50px"></th> -->
					                    </tr>
					                </thead>
					                <tbody>
					                    @foreach ($courses as $course)
					                        <tr>
					                            <td>{{ $course->id }}</td>
					                            <td>{{ $course->name }}</td>
					                            <td> 
					                                <a href="{{ url('course/') }}/edit/{{$course->id}}" class="btn btn-primary"> Edit </a>
					                                <a href="{{ url('course/delete') }}/{{$course->id}} " class="btn btn-danger" onclick="return confirm('Are you sure to delete this data?')"> Delete </a>
					                            </td>
					                        <tr>
					                    @endforeach
					                </tbody>
					            </table>
					            {{ $courses->render() }}
					        </div>
					        <a href="{{url('course/create')}}" class="btn btn-primary" role="button">Add course</a>
					    </div>
					</div>
			</div>
		</div>
	</div>
@endsection
