<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Validator;
use Redirect;
use App\User;

class UserController extends Controller{
    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'id' => 'required|unique:users',
            'name' => 'required|max:255',
            'username' => 'required|unique:users',
            'email' => 'required|email|max:255|unique:users',
            'password' => 'required|min:6|confirmed',
            'role' => 'required',
        ]);
    }

	/**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users = DB::table('users')->paginate(10);
        return view('users.index')->with('users', $users);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $classes = DB::table('classes')->get();
        
        return view('users.add')->with('classes', $classes);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $rules = array(
            'id' => 'required|unique:users',
            'name' => 'required|max:255',
            'username' => 'required|unique:users',
            'email' => 'required|email|max:255|unique:users',
            'password' => 'required|min:6|confirmed',
            'role' => 'required',
            'class_id' => 'required',
        );
        
        $valid = Validator::make($request->all(), $rules);

        if($valid->fails()){
            $mes = $valid->messages();

            // dd($mes);

            return redirect()->back()->withError($valid);
        } else{
            $datas = $request->all();

            $user = new User;
            $user->id = $datas['id'];
            $user->name = $datas['name'];
            $user->username = $datas['username'];
            $user->email = $datas['email'];
            $user->password = bcrypt($datas['password']);
            $user->role = $datas['role'];
            $user->class_id = $datas['class_id'];
            $user->save();

            $users = DB::table('users')->paginate(10);
            return redirect('/user')->with('users', $users);
        }
    }

    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = new User;
        $user = User::findOrFail($id);
        
        $classes = DB::table('classes')->get();

        return view('users.edit')->with('user', $user)
                                 ->with('classes', $classes);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $user = User::where('id',$id)->first();
        $user->name = $request['name'];
        $user->username = $request['username'];
        $user->email = $request['email'];
        $user->password = bcrypt($request['password']);
        $user->role = $request['role'];
        $user->class_id = $request['class_id'];
        $user->update();

        $users = DB::table('users')->paginate(10);
        return redirect('/user')->with('users', $users);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = User::findOrFail($id);

        $data->delete();

        $users = DB::table('users')->paginate(10);
        return redirect('/user')->with('users', $users);
    }
}
