@if(Auth::check())
    @extends('layouts.layout')
    @include('layouts.header')

    <body class="skin-blue sidebar-mini" style="height: auto;">
    <div class="wrapper" style="height: auto;">
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section id="content-menu" class="content-menu">
                <div class="module-menu-container"></div>
                <ol class="breadcrumb"><li><a href="/"><i class="fa-home"></i> Home</a></li>
                    <li class="active"><i class="fa-users"></i>User</li>
                </ol><!-- breadcrumbs -->
            </section>

            <!-- Main content -->
            <section class="content">
                <!-- /.row -->
                <div class="row">
                    <div class="col-xs-12">
                        <div class="box box-primary">
                            <div class="box-header">
                                <h3 class="box-title">User</h3>
                                <div class="box-tools">
                                    <form action="{{url('/admin/user')}}">
                                        <div class="input-group input-group-sm" style="width: 150px;">
                                            <input type="text" name="search" class="form-control pull-right"
                                                   placeholder="Username" id="search" type="text">
                                            <div class="input-group-btn">
                                                <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="form-group">
                                    <?php $jumlah=0 ?>
                                    @foreach($total as $tot)
                                        <?php $jumlah++ ?>
                                    @endforeach
                                    <h4>Total User = {{$jumlah}}</h4>
                                </div>
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body table-responsive no-padding">
                                <table class="table table-hover">
                                    <thead><tr>
                                        <th>Username User</th>
                                        <th>Role</th>
                                        <th>Aksi</th>
                                    </tr></thead>
                                    <tbody>
                                    @foreach($user as $stf)
                                        <tr>
                                            <td>{{$stf->username}}</td>
                                            <td>{{$stf->role}}</td>
                                            <td>
                                                <a href="{{url('admin/user/hapus',$stf->id)}}" class="btn btn-danger">Hapus</a>
                                            </td>
                                        </tr>
                                        </form>
                                    @endforeach
                                    </tbody>
                                </table>
                                {{$user->links()}}
                            </div>
                            <!-- /.box-body -->
                            <div class="box-footer">
                                <a href="{{url('admin/user/tambah')}}" class="btn btn-danger">Tambah User</a>
                                <i class="fa fa-user-plus"></i>
                            </div>
                        </div>
                        <!-- /.box -->
                    </div>
                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>
    </body>
@endif