<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| This file is where you may define all of the routes that are handled
| by your application. Just tell Laravel the URIs it should respond
| to using a Closure or controller method. Build something great!
|
*/
Route::get('/',function(){
    return view('auth.login');
})->middleware('guest');

Route::get('/getImport', 'ExcelController@getImport');
Route::post('/postImport', 'ExcelController@postImport');
Route::get('/getExport', 'ExcelController@getExport');
Route::get('/getPDF', 'PDFController@getPDF');
Route::get('/deleteAll', 'ExcelController@deleteAll');


// Upload didukung dari Youtube
//Judul Video adalah Laravel 5.3, 5.2 - Download Files From Database (.pdf,.doc,.png,.jpg,.xlsl etc)(360p)
Route::get('upload', 'UploadsController@index');
Route::post('upload/uploadFiles', 'UploadsController@multiple_upload');

Route::get('seeupload', 'UploadseeController@index');
Route::post('seeupload/uploadFiles', 'UploadseeController@multiple_upload');



// Routing untuk authentifikasi
Route::group(['namespace' => 'auth'],function(){
	Route::post('/login','LoginController@login')->name('login');
    Route::post('/register','RegisterController@register')->name('register');
    Route::get('/logout',function(){
        Auth::logout();
        return redirect('/');
    })->name('logout');
    Route::get('admin/resetpassword','LoginController@resetpass')->name('admin.resetpass')->middleware('admin');
    Route::get('mahasiswa/resetpassword','LoginController@resetpass')->name('mahasiswa.resetpass')->middleware('mahasiswa');
   
    Route::post('resetpassword','LoginController@reset')->name('reset');
});

// Routing untuk user level admin
Route::group(['namespace' => 'backend','prefix' => 'admin','middleware' => 'admin'], function() {
    // Controllers Within The "App\Http\Controllers\Admin" Namespace

   
    Route::get('/', function () {
	    return view('backend.dashboard',['title' => 'Dashboard']);
	})->name('admin');
   
    Route::resource('mahasiswa','MhsCtrl');
   
});

// Routing untuk user level mahasiswa
Route::group(['namespace' => 'mahasiswa','prefix' => 'mahasiswa','middleware' => 'mahasiswa'], function() {
    Route::get('/', function () {
        return view('mahasiswa.dashboard',['title' => 'Dashboard']);
    })->name('mahasiswa');

});



// CRUD buku didukung dari Youtube
//https://www.youtube.com/watch?v=H_T-2ClHvJY

Route::group(['middleware' => ['web']], function () {
      Route::resource('book', 'BookController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want adminlte:route and adminlte:link commands to works correctly.
    #adminlte_routes
});


Route::group(['middleware' => ['web']], function () {
      Route::resource('sbook', 'SBookController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want adminlte:route and adminlte:link commands to works correctly.
    #adminlte_routes
});


// Upload didukung dari Video
//Judul Video adalah Laravel 5.3, 5.2 - Download Files From Database (.pdf,.doc,.png,.jpg,.xlsl etc)(360p)
Route::group(['middleware' => ['web']], function () {
      Route::resource('upload', 'UploadsController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want adminlte:route and adminlte:link commands to works correctly.
    #adminlte_routes
});

Route::group(['middleware' => ['web']], function () {
      Route::resource('seeupload', 'UploadseeController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want adminlte:route and adminlte:link commands to works correctly.
    #adminlte_routes
});




Route::get('/home', 'HomeController@index');



