<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Validator;
use Response;
use Redirect;
use Session;
use App\verifikasis_p;
use Illuminate\Support\Facades\DB;



class verifikasis_pController extends Controller {



    public function index() {
      $verifikasis_p = DB::table('verifikasi_pengunjung')->paginate(10);
      
        return view('verifikasiPengunjung.index',['verifikasis_p' => $verifikasis_p]);
    }


      public function create()
    {
       return view('verifikasiPengunjung.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,['nama'=> 'required',]);

        $verifikasiPengunjung = new verifikasis_p;
        $verifikasiPengunjung->nama = $request->nama;
        $verifikasiPengunjung->save();
        return redirect()->route('verifikasiPengunjung.index')->with('alert-success','Data Hasbeen Saved');
    }


    public function multiple_upload() {
      // getting all of the post data
      $files = Input::file('images');
      // Making counting of uploaded images
      $file_count = count($files);
      // start count how many uploaded
      $uploadcount = 0;

      foreach ($files as $file) {
        $rules = array('file' => 'required'); //'required|mimes:png,gif,jpeg,txt,pdf,doc'
        $validator = Validator::make(array('file'=> $file), $rules);
        if($validator->passes()){
          $destinationPath = 'verifikasis_p'; // upload folder in public directory
          $filename = $file->getClientOriginalName();
          $upload_success = $file->move($destinationPath, $filename);
          $uploadcount ++;

          // save into database
          $extension = $file->getClientOriginalExtension();
          $entry = new verifikasis_p();
          $entry->mime = $file->getClientMimeType();
          $entry->original_filename = $filename;
          $entry->filename = $file->getFilename().'.'.$extension;
          $entry->save();
        }
      }
      if($uploadcount == $file_count){
        Session::flash('success', 'Upload successfully');
        return Redirect::to('verifikasiPengunjung');
      } else {
        return Redirect::to('verifikasiPengunjung')->withInput()->withErrors($validator);
      }
    }


     public function destroy($id)
    {
         $verifikasiPengunjung = verifikasis_p::findOrFail($id);
        $verifikasiPengunjung->delete();
        return redirect()->route('verifikasiPengunjung.index')->with('alert-success','Data Hasbeen Deleted');  
    }



} 